IF EXISTS ( SELECT * FROM sys.procedures WHERE name = 'P_LOG_AUDITORIA_AGENDA_COMPRA' )
BEGIN
	DROP PROCEDURE P_LOG_AUDITORIA_AGENDA_COMPRA
END
GO
CREATE PROCEDURE [dbo].P_LOG_AUDITORIA_AGENDA_COMPRA  (
	 @CD_EMP  INT = 1
	, @CD_CTR_AGENDA  INT
	, @VERSAO_SELEC  INT   --  CD_CTR  SELECIONADO
)
AS
BEGIN
	SET NOCOUNT ON;
/*

EXEC P_LOG_AUDITORIA_AGENDA_COMPRA  @CD_CTR_AGENDA = 1623	, @VERSAO_SELEC = 3

*/

SELECT
*
FROM (
SELECT
	'Tipo de Agenda' AS ALTERADO
	,CASE WHEN CONVERT( VARCHAR( 50 ) , A.TIPO_AGENDA ) = 1 THEN '01 - SUPRIMENTO'
		WHEN CONVERT( VARCHAR( 50 ) , A.TIPO_AGENDA ) = 2 THEN '02 - RESSUPRIMENTO'
		WHEN CONVERT( VARCHAR( 50 ) , A.TIPO_AGENDA ) = 3 THEN '03 - RESSUPRIMENTO FORNECEDOR'
	ELSE
		'NO INFORMADO'
	END AS VERSAO_SELECIONADA
	,CASE WHEN CONVERT( VARCHAR( 50 ) , B.TIPO_AGENDA ) = 1 THEN '01 - SUPRIMENTO'
		WHEN CONVERT( VARCHAR( 50 ) , B.TIPO_AGENDA ) = 2 THEN '02 - RESSUPRIMENTO'
		WHEN CONVERT( VARCHAR( 50 ) , B.TIPO_AGENDA ) = 3 THEN '03 - RESSUPRIMENTO FORNECEDOR'
	ELSE
		'NO INFORMADO'
	END AS VERSAO_ATUAL
	,1 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.TIPO_AGENDA <> B.TIPO_AGENDA

UNION

SELECT
	'Nome da Agenda' AS ALTERADO
	 ,CONVERT( VARCHAR( 50 ) , A.DS_AGENDAMENTO ) AS VERSAO_SELECIONADA
	 ,CONVERT( VARCHAR( 50 ) , B.DS_AGENDAMENTO ) AS VERSAO_ATUAL
	 ,2 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.DS_AGENDAMENTO <> B.DS_AGENDAMENTO

UNION

SELECT
	'Frequncia Reviso' AS ALTERADO
	,CASE WHEN CONVERT( VARCHAR( 50 ) , A.FREQ_REV ) = 1 THEN '01 - MENSAL'
		WHEN CONVERT( VARCHAR( 50 ) , A.FREQ_REV ) = 2 THEN '02 - QUINZENAL'
		WHEN CONVERT( VARCHAR( 50 ) , A.FREQ_REV ) = 4 THEN '04 - SEMANAL'
		WHEN CONVERT( VARCHAR( 50 ) , A.FREQ_REV ) = 8 THEN '08 - BISEMANAL'
		WHEN CONVERT( VARCHAR( 50 ) , A.FREQ_REV ) = 12 THEN '12 - TRISEMANAL'
		WHEN CONVERT( VARCHAR( 50 ) , A.FREQ_REV ) = 16 THEN '16 - TETRASEMANAL'
		WHEN CONVERT( VARCHAR( 50 ) , A.FREQ_REV ) = 28 THEN '28 - DIRIO'
	ELSE
		'NO INFORMADO'
	END AS VERSAO_SELECIONADA

	,CASE WHEN CONVERT( VARCHAR( 50 ) , B.FREQ_REV ) = 1 THEN '01 - MENSAL'
		WHEN CONVERT( VARCHAR( 50 ) , B.FREQ_REV ) = 2 THEN '02 - QUINZENAL'
		WHEN CONVERT( VARCHAR( 50 ) , B.FREQ_REV ) = 4 THEN '04 - SEMANAL'
		WHEN CONVERT( VARCHAR( 50 ) , B.FREQ_REV ) = 8 THEN '08 - BISEMANAL'
		WHEN CONVERT( VARCHAR( 50 ) , B.FREQ_REV ) = 12 THEN '12 - TRISEMANAL'
		WHEN CONVERT( VARCHAR( 50 ) , B.FREQ_REV ) = 16 THEN '16 - TETRASEMANAL'
		WHEN CONVERT( VARCHAR( 50 ) , B.FREQ_REV ) = 28 THEN '28 - DIRIO'
	ELSE
		'NO INFORMADO'
	END AS VERSAO_ATUAL
	,3 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.FREQ_REV <> B.FREQ_REV

UNION

SELECT
	'Lead Time' AS ALTERADO
	,CONVERT( VARCHAR( 50 ) , A.LEAD_TIME ) AS VERSAO_SELECIONADA
	,CONVERT( VARCHAR( 50 ) , B.LEAD_TIME ) AS VERSAO_ATUAL
	,4 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.LEAD_TIME <> B.LEAD_TIME

UNION

SELECT
	'Tipo Frete' AS ALTERADO
	,CASE WHEN CONVERT( VARCHAR( 50 ) , A.TIPO_FRETE ) =1 THEN '1 - CIF'
		WHEN CONVERT( VARCHAR( 50 ) , A.TIPO_FRETE ) =2 THEN '2 - FOB'
	ELSE
		'SEM DEFINIO'
	END AS VERSAO_SELECIONADA
	,CASE WHEN CONVERT( VARCHAR( 50 ) , B.TIPO_FRETE ) =1 THEN '1 - CIF'
		WHEN CONVERT( VARCHAR( 50 ) , B.TIPO_FRETE ) =2 THEN '2 - FOB'
	ELSE
		'SEM DEFINIO'
	END AS VERSAO_ATUAL
	,5 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.TIPO_FRETE <> B.TIPO_FRETE

UNION

SELECT
	'Compra Embalado' AS ALTERADO
	,CASE WHEN CONVERT( VARCHAR( 50 ) , A.COMPRA_EMBALADO ) =0 THEN '0 - NO'
		WHEN CONVERT( VARCHAR( 50 ) , A.COMPRA_EMBALADO )   =1 THEN '1 - SIM'
	ELSE
		'SEM DEFINIO'
	END AS VERSAO_SELECIONADA
	,CASE WHEN CONVERT( VARCHAR( 50 ) , B.COMPRA_EMBALADO ) =0 THEN '0 - NO'
		WHEN CONVERT( VARCHAR( 50 ) , B.COMPRA_EMBALADO )   =1 THEN '1 - SIM'
	ELSE
		'SEM DEFINIO'
	END AS VERSAO_ATUAL
	,6 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.COMPRA_EMBALADO <> B.COMPRA_EMBALADO

UNION

SELECT
	'Compra Multiplo' AS ALTERADO
	,CASE WHEN CONVERT( VARCHAR( 50 ) , A.COMPRA_MULTIPLO ) =0 THEN '0 - NO'
		WHEN CONVERT( VARCHAR( 50 ) , A.COMPRA_MULTIPLO )   =1 THEN '1 - SIM'
	ELSE
		'SEM DEFINIO'
	END AS VERSAO_SELECIONADA
	,CASE WHEN CONVERT( VARCHAR( 50 ) , B.COMPRA_MULTIPLO ) =0 THEN '0 - NO'
		WHEN CONVERT( VARCHAR( 50 ) , B.COMPRA_MULTIPLO )   =1 THEN '1 - SIM'
	ELSE
		'SEM DEFINIO'
	END AS VERSAO_ATUAL
	,7 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.COMPRA_MULTIPLO <> B.COMPRA_MULTIPLO

UNION

SELECT
	'Perc.Desc.Comercial' AS ALTERADO
	,CONVERT( VARCHAR( 50 ) , A.PERC_DESC_COMERCIAL ) AS VERSAO_SELECIONADA
	,CONVERT( VARCHAR( 50 ) , B.PERC_DESC_COMERCIAL ) AS VERSAO_ATUAL
	,8 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.PERC_DESC_COMERCIAL <> B.PERC_DESC_COMERCIAL

UNION

SELECT
	'Perc.Desc.Financeiro' AS ALTERADO
	,CONVERT( VARCHAR( 50 ) , A.PERC_DESC_FINANCEIRO ) AS VERSAO_SELECIONADA
	,CONVERT( VARCHAR( 50 ) , B.PERC_DESC_FINANCEIRO ) AS VERSAO_ATUAL
	,9 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.PERC_DESC_FINANCEIRO <> B.PERC_DESC_FINANCEIRO

UNION

SELECT
	'Prazo Pagamento' AS ALTERADO
	,CONVERT( VARCHAR( 50 ) , A.PRZ_PGTO ) AS VERSAO_SELECIONADA
	,CONVERT( VARCHAR( 50 ) , B.PRZ_PGTO ) AS VERSAO_ATUAL
	,10 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.PRZ_PGTO <> B.PRZ_PGTO

UNION

SELECT
	'Segunda' AS ALTERADO
	,CASE WHEN CONVERT( VARCHAR( 50 ) , A.SEGUNDA )=0 THEN '0 - NO' ELSE '1 - SIM' END AS VERSAO_SELECIONADA
	,CASE WHEN CONVERT( VARCHAR( 50 ) , B.SEGUNDA ) =0 THEN '0 - NO' ELSE '1 - SIM' END AS VERSAO_ATUAL
	,11 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.SEGUNDA <> B.SEGUNDA

UNION

SELECT
	'Tera' AS ALTERADO
	,CASE WHEN CONVERT( VARCHAR( 50 ) , A.TERCA )=0 THEN '0 - NO' ELSE '1 - SIM' END AS VERSAO_SELECIONADA
	,CASE WHEN CONVERT( VARCHAR( 50 ) , B.TERCA ) =0 THEN '0 - NO' ELSE '1 - SIM' END AS VERSAO_ATUAL
	,12 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.TERCA <> B.TERCA

UNION

SELECT
	'Quarta' AS ALTERADO
	,CASE WHEN CONVERT( VARCHAR( 50 ) , A.QUARTA )=0 THEN '0 - NO' ELSE '1 - SIM' END AS VERSAO_SELECIONADA
	,CASE WHEN CONVERT( VARCHAR( 50 ) , B.QUARTA ) =0 THEN '0 - NO' ELSE '1 - SIM' END AS VERSAO_ATUAL
	,13 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.QUARTA <> B.QUARTA

UNION

SELECT
	'Quinta' AS ALTERADO
	,CASE WHEN CONVERT( VARCHAR( 50 ) , A.QUINTA )=0 THEN '0 - NO' ELSE '1 - SIM' END AS VERSAO_SELECIONADA
	,CASE WHEN CONVERT( VARCHAR( 50 ) , B.QUINTA ) =0 THEN '0 - NO' ELSE '1 - SIM' END AS VERSAO_ATUAL
	,14 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.QUINTA <> B.QUINTA

UNION

SELECT
	'Sexta' AS ALTERADO
	,CASE WHEN CONVERT( VARCHAR( 50 ) , A.SEXTA )=0 THEN '0 - NO' ELSE '1 - SIM' END AS VERSAO_SELECIONADA
	,CASE WHEN CONVERT( VARCHAR( 50 ) , B.SEXTA ) =0 THEN '0 - NO' ELSE '1 - SIM' END AS VERSAO_ATUAL
	,15 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.SEXTA <> B.SEXTA


UNION

SELECT
	'Sbado' AS ALTERADO
	,CASE WHEN CONVERT( VARCHAR( 50 ) , A.SABADO )=0 THEN '0 - NO' ELSE '1 - SIM' END AS VERSAO_SELECIONADA
	,CASE WHEN CONVERT( VARCHAR( 50 ) , B.SABADO ) =0 THEN '0 - NO' ELSE '1 - SIM' END AS VERSAO_ATUAL
	,16 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.SABADO <> B.SABADO

UNION

SELECT
	'Domingo' AS ALTERADO
	,CASE WHEN CONVERT( VARCHAR( 50 ) , A.DOMINGO )=0 THEN '0 - NO' ELSE '1 - SIM' END AS VERSAO_SELECIONADA
	,CASE WHEN CONVERT( VARCHAR( 50 ) , B.DOMINGO ) =0 THEN '0 - NO' ELSE '1 - SIM' END AS VERSAO_ATUAL
	,17 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.DOMINGO <> B.DOMINGO

UNION

SELECT
	'Param.Estoque' AS ALTERADO
	,CONVERT( VARCHAR( 50 ) , A.PARAM_EST ) AS VERSAO_SELECIONADA
	,CONVERT( VARCHAR( 50 ) , B.PARAM_EST ) AS VERSAO_ATUAL
	,18 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.PARAM_EST <> B.PARAM_EST

UNION

SELECT
	'Data agendamento' AS ALTERADO
	,CONVERT( VARCHAR( 50 ) , CONVERT(VARCHAR(10),A.DT_AGENDAMENTO_DEFAULT,103) ) AS VERSAO_SELECIONADA
	,CONVERT( VARCHAR( 50 ) , CONVERT(VARCHAR(10),B.DT_AGENDAMENTO_DEFAULT,103) ) AS VERSAO_ATUAL
	,19 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.DT_AGENDAMENTO_DEFAULT <> B.DT_AGENDAMENTO_DEFAULT


UNION

SELECT
	'Tipo Compra' AS ALTERADO
	,CASE WHEN CONVERT( VARCHAR( 50 ) , A.TIPO_COMPRA ) =3 THEN 'SUPRIMENTO'
		WHEN CONVERT( VARCHAR( 50 ) , A.TIPO_COMPRA ) =4 THEN 'RESSUPRIMENTO'
		WHEN CONVERT( VARCHAR( 50 ) , A.TIPO_COMPRA ) =5 THEN 'SUP-RESSUP'
		WHEN CONVERT( VARCHAR( 50 ) , A.TIPO_COMPRA ) =6 THEN 'TODOS'
	ELSE
		'NO DEFINIDO'
	END AS VERSAO_SELECIONADA
	,CASE WHEN CONVERT( VARCHAR( 50 ) , B.TIPO_COMPRA ) =3 THEN 'SUPRIMENTO'
		WHEN CONVERT( VARCHAR( 50 ) , B.TIPO_COMPRA ) =4 THEN 'RESSUPRIMENTO'
		WHEN CONVERT( VARCHAR( 50 ) , B.TIPO_COMPRA ) =5 THEN 'SUP-RESSUP'
		WHEN CONVERT( VARCHAR( 50 ) , B.TIPO_COMPRA ) =6 THEN 'TODOS'
	ELSE
		'NO DEFINIDO'
	END AS VERSAO_ATUAL
	,20 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.TIPO_COMPRA <> B.TIPO_COMPRA


UNION

SELECT
	'Qtde. Dias Acrescimo' AS ALTERADO
	,CONVERT( VARCHAR( 50 ) , A.QT_DIAS_ACRES_AGENDA ) AS VERSAO_SELECIONADA
	,CONVERT( VARCHAR( 50 ) , B.QT_DIAS_ACRES_AGENDA ) AS VERSAO_ATUAL
	,21 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND A.QT_DIAS_ACRES_AGENDA <> B.QT_DIAS_ACRES_AGENDA

UNION

SELECT
	'Dt.Valid.Acres.Agenda' AS ALTERADO
	,ISNULL(CONVERT( VARCHAR( 50 ) , CONVERT(VARCHAR(10),A.DT_VALID_ACRES_AGENDA,103) ),'') AS VERSAO_SELECIONADA
	,ISNULL(CONVERT( VARCHAR( 50 ) , CONVERT(VARCHAR(10),B.DT_VALID_ACRES_AGENDA,103) ),'') AS VERSAO_ATUAL
	,22 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND isnull(A.DT_VALID_ACRES_AGENDA,'') <> isnull(B.DT_VALID_ACRES_AGENDA,'')

UNION

SELECT
	'Flag Gerar Agenda' AS ALTERADO
	,CASE WHEN CONVERT( VARCHAR( 50 ) , ISNULL(A.FLAG_GERAR_AGENDA,0) )=0 THEN '0 - DESMARCADO' ELSE '1 - MARCADO' END AS VERSAO_SELECIONADA
	,CASE WHEN CONVERT( VARCHAR( 50 ) , ISNULL(B.FLAG_GERAR_AGENDA,0) ) =0 THEN '0 - DESMARCADO' ELSE '1 - MARCADO' END AS VERSAO_ATUAL
	,23 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND ISNULL(A.FLAG_GERAR_AGENDA,0) <> ISNULL(B.FLAG_GERAR_AGENDA,0)

UNION

SELECT
	'Lista de Preo' AS ALTERADO
	,CASE WHEN CONVERT( VARCHAR( 50 ) , ISNULL(A.FLAG_LST_PRECO,0) )=0 THEN '0 - DESMARCADO' ELSE '1 - MARCADO' END AS VERSAO_SELECIONADA
	,CASE WHEN CONVERT( VARCHAR( 50 ) , ISNULL(B.FLAG_LST_PRECO,0) )=0 THEN '0 - DESMARCADO' ELSE '1 - MARCADO' END AS VERSAO_ATUAL
	,24 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND ISNULL(A.FLAG_LST_PRECO,0) <> ISNULL(B.FLAG_LST_PRECO,0)

UNION

SELECT
	'Grupo possui Produtos' AS ALTERADO
	,CASE WHEN CONVERT( VARCHAR( 50 ) , ISNULL(A.FLAG_GRUPO_POSSUI_PRODUTOS,0) )=0 THEN '0 - DESMARCADO' ELSE '1 - MARCADO' END AS VERSAO_SELECIONADA
	,CASE WHEN CONVERT( VARCHAR( 50 ) , ISNULL(B.FLAG_GRUPO_POSSUI_PRODUTOS,0) )=0 THEN '0 - DESMARCADO' ELSE '1 - MARCADO' END AS VERSAO_ATUAL
	,25 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND ISNULL(A.FLAG_GRUPO_POSSUI_PRODUTOS,0) <> ISNULL(B.FLAG_GRUPO_POSSUI_PRODUTOS,0)

UNION

SELECT
	'Status Agenda' AS ALTERADO
	,CASE WHEN CONVERT( VARCHAR( 50 ) , ISNULL(A.STS_AGENDA,0) )=0 THEN '0 - ATIVO' ELSE '1 - INATIVO' END AS VERSAO_SELECIONADA
	,CASE WHEN CONVERT( VARCHAR( 50 ) , ISNULL(B.STS_AGENDA,0) )=0 THEN '0 - ATIVO' ELSE '1 - INATIVO' END AS VERSAO_ATUAL
	,26 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND ISNULL(A.STS_AGENDA,0) <> ISNULL(B.STS_AGENDA,0)

UNION

SELECT
	'Cd.Filial Depsito' AS ALTERADO
	,CONVERT( VARCHAR( 50 ) , ISNULL(A.CD_FILIAL_DEPO,'') ) AS VERSAO_SELECIONADA
	,CONVERT( VARCHAR( 50 ) , ISNULL(B.CD_FILIAL_DEPO,'') ) AS VERSAO_ATUAL
	,27 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND ISNULL(A.CD_FILIAL_DEPO,'') <> ISNULL(B.CD_FILIAL_DEPO,'')

--UNION

--SELECT
--	'Dt.ltima Alterao' AS ALTERADO
--	,ISNULL(CONVERT( VARCHAR( 50 ) , CONVERT(VARCHAR(10),A.DT_ULT_ALT,103) ),'') AS VERSAO_SELECIONADA
--	,ISNULL(CONVERT( VARCHAR( 50 ) , CONVERT(VARCHAR(10),B.DT_ULT_ALT,103) ),'') AS VERSAO_ATUAL
--	,28 AS ORDEM
--FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
--	A.CD_EMP=B.CD_EMP AND
--	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

--WHERE A.CD_EMP=1
--	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
--	AND A.CD_CTR=@VERSAO_SELEC
--	AND isnull(A.DT_ULT_ALT,'') <> isnull(B.DT_ULT_ALT,'')

UNION

SELECT
	'Flag No Enviar PBM' AS ALTERADO
	,CASE WHEN CONVERT( VARCHAR( 50 ) , ISNULL(A.FLAG_NAO_ENVIAR_PBM,0) )=0 THEN '0 - DESMARCADO' ELSE '1 - MARCADO' END AS VERSAO_SELECIONADA
	,CASE WHEN CONVERT( VARCHAR( 50 ) , ISNULL(B.FLAG_NAO_ENVIAR_PBM,0) )=0 THEN '0 - DESMARCADO' ELSE '1 - MARCADO' END AS VERSAO_ATUAL
	,29 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND ISNULL(A.FLAG_NAO_ENVIAR_PBM,0) <> ISNULL(B.FLAG_NAO_ENVIAR_PBM,0)


UNION

SELECT
	'Observao' AS ALTERADO
	,ISNULL(CONVERT( VARCHAR( 50 ) , A.OBSERVACAO,103),'') AS VERSAO_SELECIONADA
	,ISNULL(CONVERT( VARCHAR( 50 ) , B.OBSERVACAO,103),'') AS VERSAO_ATUAL
	,30 AS ORDEM
FROM EST_PROD_AGENDA_COMPRA_AUDITORIA A INNER JOIN EST_PROD_AGENDA_COMPRA B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_CTR_AGENDA=B.CD_CTR_AGENDA

WHERE A.CD_EMP=1
	AND A.CD_CTR_AGENDA=@CD_CTR_AGENDA
	AND A.CD_CTR=@VERSAO_SELEC
	AND isnull(A.OBSERVACAO,'') <> isnull(B.OBSERVACAO,'')
)AUDT
ORDER BY ORDEM

END;

